<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Resources\Json\JsonResource;

class UsersResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $therapist = $this->relationLoaded('therapist') ? $this->whenLoaded('therapist'):null;
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer'):null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community'):null;


        $logged_in_as = $request->session()->get('logged_in_as');


        if($logged_in_as == 'therapist' && $therapist){
            if($therapist->pricing_plan){
                $pricing_plan = $therapist->pricing_plan;
                $therapist_modules = $pricing_plan->therapist_modules()->pluck('pricing_plan_modules.module_code')->toArray();
            }else{
                $therapist_modules = [];
            }
            $login_info = new TherapistsResource($therapist);
        }else if($logged_in_as == 'therapist_community' && $therapist_community){
            if($therapist_community->pricing_plan){
                $pricing_plan = $therapist_community->pricing_plan;
                $therapist_community_modules = $pricing_plan->therapist_community_modules()->pluck('pricing_plan_modules.module_code')->toArray();
            }else{
                $therapist_community_modules = [];
            }
            $login_info = new TherapistCommunitysResource($therapist_community);
        }else if($logged_in_as == 'customer' && $customer){
            $login_info = new CustomersResource($customer);
        }
        else{
            $login_info = null;
        }
        return [
                "id" => $this->id,
                "name" => $this->name,
                "email" => $this->email,
                "is_active" => $this->is_active,
                "country_id" => $this->country_id,
                "email_verified_at" => $this->email_verified_at,
                "is_email_verified" => $this->hasVerifiedEmail(),
                "profile_image_path" => $this->profile_image_path,
                "password_last_changed" => $this->password_last_changed,
                "is_therapist" => $this->hasRole('therapist'),
                "is_customer" => $this->hasRole('customer'),
                "is_therapist_community" => $this->hasRole('therapist_community'),
                'therapist_modules' => $therapist_modules ?? [],
                'therapist_community_modules' => $therapist_community_modules ?? [],
                'login_info' => $login_info,
                "created_at" => $this->created_at,
                "updated_at" => $this->updated_at,
                "deleted_at" =>  $this->deleted_at
        ];
    }
}
